# --
# Copyright (C) 2001-2021 OTRS AG, https://otrs.com/
# Copyright (C) 2021 Znuny GmbH, https://znuny.org/
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see https://www.gnu.org/licenses/gpl-3.0.txt.
# --

#
# WARNING: This file is autogenerated from "scripts/auto_build/spec/templates" via
# "bin/znuny.Console.pl Dev::Tools::RPMSpecGenerate". All changes will be lost.
#

Summary:      The Znuny service desk.
Name:         znuny
Version:      0.0
License:      GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007
Group:        Applications/Mail
Provides:     znuny
Obsoletes:    otrs <= 6.0.30
Requires:     bash-completion cronie apache2 apache2-mod_perl perl perl(Archive::Zip) perl(Date::Format) perl(DateTime) perl(DBI) perl(Encode::HanExtra) perl(IO::Socket::SSL) perl(JSON::XS) perl(LWP::UserAgent) perl(Net::DNS) perl(Net::LDAP) perl(Template) perl(Text::CSV) perl(Text::CSV_XS) perl(URI) perl(XML::LibXML) perl(XML::LibXSLT) perl(XML::Parser) perl(YAML::XS) procmail
AutoReqProv:  no
Release:      01
Source0:      znuny-%{version}.tar.bz2
BuildArch:    noarch
BuildRoot:    %{_tmppath}/%{name}-%{version}-build

%description
Znuny is an Open source Ticket Request System with many features to manage
customer telephone calls and e-mails. It is distributed under the GNU
General Public License (GPL) and tested on Linux and Mac OS. Do you
receive many e-mails and want to answer them with a team of agents?
You're going to love Znuny!

SuSE series: ap

%prep
%setup

%build
# copy config file
cp Kernel/Config.pm.dist Kernel/Config.pm
# rename config POD file
mv Kernel/Config.pod.dist Kernel/Config.pod
# copy all crontab dist files
for foo in var/cron/*.dist; do mv $foo var/cron/`basename $foo .dist`; done
# copy all .dist files
cp .procmailrc.dist .procmailrc
cp .fetchmailrc.dist .fetchmailrc
cp .mailfilter.dist .mailfilter

%install
# delete old RPM_BUILD_ROOT
rm -rf $RPM_BUILD_ROOT
# set DESTROOT
export DESTROOT="/opt/znuny/"
# create RPM_BUILD_ROOT DESTROOT
mkdir -p $RPM_BUILD_ROOT/$DESTROOT/
# copy files
cp -R . $RPM_BUILD_ROOT/$DESTROOT
# configure apache
install -d -m 755 $RPM_BUILD_ROOT/etc/apache2/conf.d
install -m 644 scripts/apache2-httpd.include.conf $RPM_BUILD_ROOT/etc/apache2/conf.d/zzz_znuny.conf

# set permission

export ZNUNYUSER=znuny
useradd $ZNUNYUSER || :
useradd wwwrun || :
groupadd www || :
$RPM_BUILD_ROOT/opt/znuny/bin/znuny.SetPermissions.pl --web-group=www

%pre
# useradd
export ZNUNYUSER=znuny
echo -n "Check Znuny user ... "
if id $ZNUNYUSER >/dev/null 2>&1; then
    echo "$ZNUNYUSER exists."
    # update groups
    usermod -g www $ZNUNYUSER
    # update home dir
    usermod -d /opt/znuny $ZNUNYUSER
else
    useradd $ZNUNYUSER -d /opt/znuny/ -s /bin/bash -g www -c 'Znuny System User' && echo "$ZNUNYUSER added."
fi
echo "Enable apache module mod_perl..."
a2enmod perl
echo "Enable apache module mod_version..."
a2enmod version
echo "Enable apache module mod_deflate..."
a2enmod deflate
echo "Enable apache module mod_filter..."
a2enmod filter
echo "Enable apache module mod_headers..."
a2enmod headers

%post
export ZNUNYUSER=znuny

# note
HOST=`hostname -f`
echo ""
echo "Next steps: "
echo ""
echo "[restart web server]"
echo " systemctl restart apache2.service"
echo ""
echo "[install the Znuny database]"
echo " Make sure your database server is running."
echo " Use a web browser and open this link:"
echo " http://$HOST/znuny/installer.pl"
echo ""
echo "[start Znuny daemon and corresponding watchdog cronjob]"
echo " /opt/znuny/bin/znuny.Daemon.pl start"
echo " /opt/znuny/bin/Cron.sh start"
echo ""

%clean
rm -rf $RPM_BUILD_ROOT

%files
%config /etc/apache2/conf.d/zzz_znuny.conf

%defattr(-, znuny, www, -)
%config(noreplace) /opt/znuny/Kernel/Config.pm
%attr(-, znuny, root,) %config(noreplace) /opt/znuny/.procmailrc
%config(noreplace) /opt/znuny/.fetchmailrc
%config(noreplace) /opt/znuny/.mailfilter

%dir /opt/znuny
/opt/znuny/RELEASE
/opt/znuny/ARCHIVE
/opt/znuny/.bash_completion
/opt/znuny/.procmailrc.dist
/opt/znuny/.fetchmailrc.dist
/opt/znuny/.mailfilter.dist

%dir /opt/znuny/Custom/
/opt/znuny/Custom/README

%dir /opt/znuny/Kernel/

%dir /opt/znuny/Kernel/Config/
/opt/znuny/Kernel/Config.pm.dist
/opt/znuny/Kernel/Config.pod
/opt/znuny/Kernel/Config/Files/
/opt/znuny/Kernel/Config/Defaults.pm

/opt/znuny/Kernel/GenericInterface*

/opt/znuny/Kernel/Language.pm
%dir /opt/znuny/Kernel/Language/
/opt/znuny/Kernel/Language/*.pm

/opt/znuny/bin*
/opt/znuny/Kernel/Autoload*
/opt/znuny/Kernel/Modules*
/opt/znuny/Kernel/Output*
/opt/znuny/Kernel/System*
/opt/znuny/scripts*
/opt/znuny/i18n/Znuny/*

%dir /opt/znuny/var/
%dir /opt/znuny/var/article/
/opt/znuny/var/fonts/
/opt/znuny/var/httpd/
%dir /opt/znuny/var/cron/
%dir /opt/znuny/var/log/
%dir /opt/znuny/var/sessions/
%dir /opt/znuny/var/spool/
/opt/znuny/var/cron/*
%dir /opt/znuny/var/tmp/
%dir /opt/znuny/var/stats/
/opt/znuny/var/stats/*.xml
%dir /opt/znuny/var/stats/formatdefinition/excel/
/opt/znuny/var/stats/formatdefinition/excel/*
%dir /opt/znuny/var/processes/examples/
/opt/znuny/var/processes/examples/*
%dir /opt/znuny/var/webservices/examples/
/opt/znuny/var/webservices/examples/*.pm
/opt/znuny/var/webservices/examples/*.yml

/opt/znuny/Kernel/cpan-lib*

%doc /opt/znuny/*.md
%doc /opt/znuny/COPYING
%doc /opt/znuny/COPYING-Third-Party
%doc /opt/znuny/doc*
