# --
# Copyright (C) 2001-2021 OTRS AG, https://otrs.com/
# Copyright (C) 2021 Znuny GmbH, https://znuny.org/
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see https://www.gnu.org/licenses/gpl-3.0.txt.
# --

package Kernel::System::SupportDataCollector::Plugin::Znuny::DaemonRunning;

use strict;
use warnings;

use Kernel::System::ObjectManager;

use parent qw(Kernel::System::SupportDataCollector::PluginBase);

use Kernel::Language qw(Translatable);

our @ObjectDependencies = (
    'Kernel::Config',
    'Kernel::System::Cache',
);

sub GetDisplayPath {
    return Translatable('Znuny');
}

sub Run {
    my $Self = shift;

    # get config object
    my $ConfigObject = $Kernel::OM->Get('Kernel::Config');

    # get the NodeID from the SysConfig settings, this is used on High Availability systems.
    my $NodeID = $ConfigObject->Get('NodeID') || 1;

    # get running daemon cache
    my $Running = $Kernel::OM->Get('Kernel::System::Cache')->Get(
        Type => 'DaemonRunning',
        Key  => $NodeID,
    );

    if ($Running) {
        $Self->AddResultOk(
            Label   => Translatable('Daemon'),
            Value   => 1,
            Message => Translatable('Daemon is running.'),
        );
    }
    else {
        $Self->AddResultProblem(
            Label   => Translatable('Daemon'),
            Value   => 0,
            Message => Translatable('Daemon is not running.'),
        );
    }

    return $Self->GetResults();
}

1;
